//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Modify Items
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// Modifies items to add some quality of life to certain things.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Makes the items on the list stackable
const stackableItems = [
	"deeperdarker:heart_of_the_deep",
	"projectexpansion:final_star",
	"projectexpansion:final_star_shard",
	"minecraft:potion",
	"minecraft:splash_potion",
	"minecraft:lingering_potion",
	"projectexpansion:infinite_fuel",
    "ironfurnaces:million_furnace",
	"mob_grinding_utils:mob_swab"
]

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Applies modifications
ItemEvents.modification(event => {
	// Alters the stack size of items
	if (stackableItems.length > 0)
	{
		stackableItems.forEach(id => {
			event.modify(id, item => {
				item.maxStackSize = 64
			});
		});
	}
});